FUNCTION_BLOCK fbSynchroTime
(*
   Synchronizovat datum a cas PLC podle casoveho serveru na internetu
*)
  VAR_INPUT
    ethCode  : UINT;              // kd ethernet kanlu (ETH1_uni0, ETH1_uni1, ...)
  END_VAR
  VAR_OUTPUT
    actDate  : DATE;              // datum
    actTime  : TIME;              // as
  END_VAR
  VAR
    NtpName  : STRING := 'cz.pool.ntp.org';
    NtpIP    : TIPadr;
    NsLookUp : fbNsLookUpEx;
    Sntp     : fbSntp;
    now      : TIME;
    cntSntp  : UDINT;
    NTPDone      : Bool;
    NTPBusy    :  Bool;
    NTPErr     : Bool;
    NTPErrId   : USINT;
    NSDone      : Bool;
    NSBusy    :  Bool;
    NSErr     : Bool;
    NSErrId : USINT;
    ZistenaIP:TIPadr;
    ZistenaIPString:String;

  END_VAR

  now := GetTime();
  ZistenaIP:=GetDNS_IP(ethChan:=ETH1);
//  NsLookUp( getIP := (now > T#18:55:00.0) AND (now < T#18:57:00.0),
//            DnsIP :=  ZistenaIP, Name := NtpName, IP := NtpIP, Done => NSDone, Busy => NSBusy, Err => NSErr, ErrId => NSErrId);
  NsLookUp( getIP := (now > T#18:55:00.0) AND (now < T#18:57:00.0),
            DnsIP :=  ZistenaIP, Name := NtpName, IP := NtpIP);

  ZistenaIPString:=IPADR_TO_STRING(IPAdr:=NtpIP);
//  NtpIp:=STRING_TO_IPADR('93.99.5.140');
  IF NsLookUp.Done THEN casZmeny:= GetTime();  END_IF;

  Sntp( Get := NsLookUp.Done, Accept := Sntp.Done, chanCode := ethCode, IPadr := NtpIP, UtcOff := 60);
//  Sntp( Get := NsLookUp.Done, Accept := Sntp.Done , chanCode := ethCode, IPadr := NtpIP, UtcOff := 60, Done=> NTPDone, Busy => NTPBusy, Err => NTPErr, ErrId => NTPErrId);
  IF Sntp.Done THEN cntSntp := cntSntp + 1;  END_IF;

  // aktualni datum a cas
  actDate := GetDate(); actTime := GetTime();
  Datum:= DATE_TO_STRINGF(in:=actDate,format:='%TDD.MM.YYYY');
END_FUNCTION_BLOCK
