(* Upozornen *)
(* Soubor je automaticky regenerovn a vechny rucn modifikace budou ztracen. *)
(* ---------------------------------------------------------------------- *)
(* Generovno pro TC700 *)
(* ********************************************************************** *)
VAR_GLOBAL CONSTANT
  CPU_TYPE   : USINT := 75;
  CPU_CODE   : UINT  := 1005;
END_VAR

TYPE
  TAIStat : STRUCT
    UNF     : BOOL;
    UNR     : BOOL;
    OVR     : BOOL;
    OVF     : BOOL;
    FLS     : BOOL;
    CJC     : BOOL;
    dummy6 {HIDDEN} : BOOL;
    dummy7 {HIDDEN} : BOOL;
    CHC     : BOOL;
    dummy9 {HIDDEN} : BOOL;
    dummy10 {HIDDEN} : BOOL;
    dummy11 {HIDDEN} : BOOL;
    dummy12 {HIDDEN} : BOOL;
    dummy13 {HIDDEN} : BOOL;
    dummy14 {HIDDEN} : BOOL;
    dummy15 {HIDDEN} : BOOL;
  END_STRUCT;

  TAI : STRUCT
    STAT  : TAIStat;
    FS    : INT;
    ENG   : REAL;
    PCT   : REAL;
  END_STRUCT;

  TAO_TC6 : STRUCT
    FS  : INT ;
    ENG  : REAL;
    PCT  : REAL;
  END_STRUCT;

  TBIN_6DI : STRUCT
    DI0  : BOOL;
    DI1  : BOOL;
    DI2  : BOOL;
    DI3  : BOOL;
    DI4  : BOOL;
    DI5  : BOOL;
  END_STRUCT;

  TBIN_4DIP  : STRUCT
    DIP0  : BOOL;
    DIP1  : BOOL;
    DIP2  : BOOL;
    DIP3  : BOOL;
  END_STRUCT;

  TBIN_4DIPW : STRUCT
    DIP0  : BOOL;
    DIP1  : BOOL;
    DIP2  : BOOL;
    DIP3  : BOOL;
  END_STRUCT;

  TBIN_4DI : STRUCT
    DI0  : BOOL;
    DI1  : BOOL;
    DI2  : BOOL;
    DI3  : BOOL;
  END_STRUCT;

  TBIN_12DI : STRUCT
    DI0  : BOOL;
    DI1  : BOOL;
    DI2  : BOOL;
    DI3  : BOOL;
    DI4  : BOOL;
    DI5  : BOOL;
    DI6  : BOOL;
    DI7  : BOOL;
    DI8  : BOOL;
    DI9  : BOOL;
    DI10  : BOOL;
    DI11  : BOOL;
  END_STRUCT;

  TCNTF_IN : STRUCT
    SCNT : UINT;
    VALA : UDINT;
    VALB : UDINT;
  END_STRUCT;

  TCNTF_OUT : STRUCT
    CCNT: UINT; 
    SET : UDINT;
  END_STRUCT;

  TBIN_6DO : STRUCT
    DO0  : BOOL;
    DO1  : BOOL;
    DO2  : BOOL;
    DO3  : BOOL;
    DO4  : BOOL;
    DO5  : BOOL;
  END_STRUCT;

  TBIN_8DO : STRUCT
    DO0  : BOOL;
    DO1  : BOOL;
    DO2  : BOOL;
    DO3  : BOOL;
    DO4  : BOOL;
    DO5  : BOOL;
    DO6  : BOOL;
    DO7  : BOOL;
  END_STRUCT;

  TCHStatistic : STRUCT
    STAT       : USINT;
    ERR        : USINT;
    trueMes    : UDINT;
    falseMes   : UDINT;
  END_STRUCT;

  TETHStatistic_UNI : STRUCT
    STAT       : USINT;
    ERR        : USINT;
    trueMes    : UDINT;
    falseMes   : UDINT;
  END_STRUCT;

  TCHControl : STRUCT
    CONTROL  : UINT;
  END_STRUCT;

  TETHControl_UNI : STRUCT
    CONTROL  : UINT;
  END_STRUCT;

  TUniStat : STRUCT
    DSR    : BOOL;
    CTS    : BOOL;
    dummy1 {HIDDEN} : BOOL;
    TRO    : BOOL;
    RCF    : BOOL;
    ROV    : BOOL;
    TRF    : BOOL;
    ARC    : BOOL;
  END_STRUCT;

  TUniCont : STRUCT
    dummy0 {HIDDEN} : BOOL;
    dummy1 {HIDDEN} : BOOL;
    dummy2 {HIDDEN} : BOOL;
    dummy3 {HIDDEN} : BOOL;
    dummy4 {HIDDEN} : BOOL;
    TRG    : BOOL;
    CLR    : BOOL;
    ACN    : BOOL;
  END_STRUCT;

  TUniSign : STRUCT
    DTR : BOOL;
    RTS : BOOL;
  END_STRUCT;

END_TYPE
(* ********************************************************************** *)
(* ---------------------------------------------------------------------- *)
(* CP-1005 *)
TYPE
  TETHStatistic_UNI0 : STRUCT
    STAT : USINT;
    ERR : USINT;
    trueMes : UDINT;
    falseMes : UDINT;
  END_STRUCT;
END_TYPE

TYPE
  TETHControl_UNI0 : STRUCT
    CONTROL : UINT ;
  END_STRUCT;
END_TYPE

TYPE
  TUNI_ETH1_IN0 : STRUCT
    STAT : TUniStat;
    ERR : USINT;
    NUMR : UINT ;
    DATA : ARRAY [0..59] OF USINT;
  END_STRUCT;
END_TYPE

TYPE
  TUNI_ETH1_OUT0 : STRUCT
    CONT : TUniCont;
    SIGN : TUniSign;
    NUMT : UINT ;
    DATA : ARRAY [0..59] OF USINT;
  END_STRUCT;
END_TYPE

VAR_GLOBAL
  r0_p0_Statistic_CH1  AT %X7500 : TCHStatistic;
  r0_p0_Control_CH1    AT %Y7500 : TCHControl;
  r0_p0_Statistic_ETH1_UNI0 AT %X7640 : TETHStatistic_UNI0;
  r0_p0_Control_ETH1_UNI0 AT %Y7624 : TETHControl_UNI0;
  UNI_ETH1_IN0         : TUNI_ETH1_IN0;
  UNI_ETH1_OUT0        : TUNI_ETH1_OUT0;
(* alias *)
  ETH1_UNI0_IN         AT UNI_ETH1_IN0.DATA;
  ETH1_UNI0_OUT        AT UNI_ETH1_OUT0.DATA;
END_VAR
(* ---------------------------------------------------------------------- *)
(* MI2-01M *)
VAR_GLOBAL
  r0_p2_Statistic_MI_CIB1 AT %X0   : TCHStatistic;
  r0_p2_Control_MI_CIB1 AT %Y0   : TCHControl;
(* alias *)
  Svetlo_Obyvacka_Sedacka AT MI_CIB1_OUT.ID1_OUT.OUT.OUT1;
  Svetlo_Spalna_Hore   AT MI_CIB1_OUT.ID1_OUT.OUT.OUT2;
END_VAR
(* ---------------------------------------------------------------------- *)
(* IR-1064 *)
VAR_GLOBAL
  r0_p3_DI             AT %X10  : TBIN_6DI;
  r0_p3_dummy0         AT %X11  : USINT;
  r0_p3_AI0            AT %X12  : TAI;
  r0_p3_AI1            AT %X24  : TAI;
  r0_p3_AI2            AT %X36  : TAI;
  r0_p3_AI3            AT %X48  : TAI;
  r0_p3_AI4            AT %X60  : TAI;
  r0_p3_AI5            AT %X72  : TAI;
  r0_p3_DO             AT %Y2   : TBIN_6DO;
  r0_p3_dummy1         AT %Y3   : USINT;
  r0_p3_AO0            AT %Y4   : TAO_TC6;
  r0_p3_AO1            AT %Y14  : TAO_TC6;
(* alias *)
  Svetlo_Chodba_dole   AT r0_p3_DO.DO0;
  Svetlo_Kuchyna       AT r0_p3_DO.DO2;
  Svetlo_Schody        AT r0_p3_DO.DO1;
  Tlacitko_Chodba_dole AT r0_p3_DI.DI0;
  Tlacitko_Chodba_Hore AT r0_p3_DI.DI5;
  Tlacitko_Kuchyna     AT r0_p3_DI.DI3;
  Tlacitko_Obyvacka    AT r0_p3_DI.DI4;
  Tlacitko_Schody      AT r0_p3_DI.DI2;
  Tlacitko_Vchod       AT r0_p3_DI.DI1;
  Zasuvka_pred_domom   AT r0_p3_DO.DO3;		(*nepouzite*)
END_VAR
(* nepouzite		r0_p3_DO.DO3 *)
(* nepouzite		r0_p3_DO.DO4 *)
(* nepouzite		r0_p3_DO.DO5 *)
(* ********************************************************************** *)
(* ---------------------------------------------------------------------- *)
(* IR-1501 *)
VAR_GLOBAL
  r1_p0_DI             AT %X84  : TBIN_4DI;
  r1_p0_DIP            AT %X85  : TBIN_4DIP;
  r1_p0_CNT_IN1        AT %X86  : TCNTF_IN;
  r1_p0_CNT_IN2        AT %X96  : TCNTF_IN;
  r1_p0_DO             AT %Y24  : TBIN_8DO;
  r1_p0_dummy          AT %Y25  : USINT;
  r1_p0_CNT_OUT1       AT %Y26  : TCNTF_OUT;
  r1_p0_CNT_OUT2       AT %Y32  : TCNTF_OUT;
(* alias *)
  Svetlo_Domus         AT r1_p0_DO.DO4;
  Svetlo_Garaz         AT r1_p0_DO.DO1;
  Svetlo_Herna         AT r1_p0_DO.DO6;
  Svetlo_Chodba_Hore   AT r1_p0_DO.DO3;
  Svetlo_Matus         AT r1_p0_DO.DO5;
  Svetlo_Obyvacka_Stol AT r1_p0_DO.DO7;
  Svetlo_Spalna_Dole   AT r1_p0_DO.DO0;
  Svetlo_Vchod         AT r1_p0_DO.DO2;
  Tlacitko_Branka      AT r1_p0_DI.DI2;		(*nepouzite*)
  Tlacitko_Posuvna_Brana AT r1_p0_DI.DI1;		(*nepouzite*)
  Tlacitko_pred_Garazou AT r1_p0_DI.DI0;		(*nepouzite*)
END_VAR
(* nepouzite		r1_p0_DI.DI0 *)
(* nepouzite		r1_p0_DI.DI1 *)
(* nepouzite		r1_p0_DI.DI2 *)
(* nepouzite		r1_p0_DI.DI3 *)
(* ---------------------------------------------------------------------- *)
(* IB-1301 *)
VAR_GLOBAL
  r1_p1_DI             AT %X106 : TBIN_12DI;
  r1_p1_DIPW           AT %X108 : TBIN_4DIPW;
  r1_p1_CNT_IN1        AT %X110 : TCNTF_IN;
  r1_p1_CNT_IN2        AT %X120 : TCNTF_IN;
  r1_p1_CNT_OUT1       AT %Y39  : TCNTF_OUT;
  r1_p1_CNT_OUT2       AT %Y45  : TCNTF_OUT;
(* alias *)
  Senzor_Garaz_brana   AT r1_p1_DI.DI11;		(*nepouzite*)
  Tlacitko_Domus       AT r1_p1_DI.DI7;
  Tlacitko_Garaz       AT r1_p1_DI.DI9;
  Tlacitko_Herna       AT r1_p1_DI.DI8;
  Tlacitko_Matus       AT r1_p1_DI.DI6;
  Tlacitko_Obyvacka_Stol AT r1_p1_DI.DI10;
  Tlacitko_Spalna_Dole AT r1_p1_DI.DI4;
  Tlacitko_Spalna_Hore AT r1_p1_DI.DI5;
END_VAR
(* nepouzite		r1_p1_DI.DI0 *)
(* nepouzite		r1_p1_DI.DI1 *)
(* nepouzite		r1_p1_DI.DI11 *)
(* nepouzite		r1_p1_DI.DI2 *)
(* nepouzite		r1_p1_DI.DI3 *)
(* ---------------------------------------------------------------------- *)
(* IR-1501 *)
VAR_GLOBAL
  r1_p2_DI             AT %X130 : TBIN_4DI;
  r1_p2_DIP            AT %X131 : TBIN_4DIP;
  r1_p2_CNT_IN1        AT %X132 : TCNTF_IN;
  r1_p2_CNT_IN2        AT %X142 : TCNTF_IN;
  r1_p2_DO             AT %Y51  : TBIN_8DO;
  r1_p2_dummy          AT %Y52  : USINT;
  r1_p2_CNT_OUT1       AT %Y53  : TCNTF_OUT;
  r1_p2_CNT_OUT2       AT %Y59  : TCNTF_OUT;
(* alias *)
  Brana                AT r1_p2_DO.DO1;
  Branka               AT r1_p2_DO.DO2;
  Garazova_Brana       AT r1_p2_DO.DO3;
  Posuvna_Brana_Senzor AT r1_p2_DI.DI3;
  Svetlo_pred_Garazou  AT r1_p2_DO.DO0;
END_VAR
(* -- *)
(* -- *)
VAR_EXTERNAL
END_VAR
(* -- *)

(* ********************************************************************** *)
(* Generovno programem MOSAIC *)
(*  2001-2019 Teco a.s. *)
(* Verze : 1.2 *)
(* DLL Verze : 20.1.0.4 *)
